<?php
/**
 * @version     3.0.2
 * @package     com_gagallery
 * @copyright   Copyright (C) 2021. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Glenn Arkell <glenn@glennarkell.com.au> - http://www.glennarkell.com.au
 */

namespace GlennArkell\Component\Gagallery\Administrator\Field;

\defined('JPATH_BASE') or die;

// import the list field type
use \Joomla\CMS\Factory;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\Form\Field\ListField;
use \Joomla\CMS\Component\ComponentHelper;
use \GlennArkell\Component\Gagallery\Administrator\Helper\GagalleryHelper;

class HcategoryField extends ListField
{
	/**
	 * The form field type.
	 *
	 * @var		string
	 * @since	1.6
	 */
	protected $type = 'Hcategory';

	/**
	 * Name of the layout being used to render the field
	 * @var    string
	 * @since  4.0.0
	 */
	protected $layout = 'joomla.form.field.list';

    /**
     * Method to get a list of options for a list input.
     *
     * @return      array           An array of JHtml options.
     */
    protected function getOptions()
    {
		// check if installed
		$Hcomp = ComponentHelper::getComponent('com_hikashop', true)->enabled;
        if (empty($Hcomp)) {
            $options = array(0=>'Not Installed');
        } else {
            $options = array();
            $options = GagalleryHelper::getListOptions('#__hikashop_category', 'Category', 'category_id', 'category_name' );
        }


        if (is_null($options)) { $options = array(); }

        $options = array_merge(parent::getOptions(), $options);

        return $options;
    }
}
