<?php
/**
 * @version    3.0.2
 * @package    com_gagallery
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2021 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace GlennArkell\Component\Gagallery\Administrator\Model;

// No direct access.
defined('_JEXEC') or die;

use \Joomla\CMS\Table\Table;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\Plugin\PluginHelper;
use \Joomla\CMS\MVC\Model\AdminModel;
use \Joomla\Event\Dispatcher;
use \Joomla\CMS\Helper\TagsHelper;
use \GlennArkell\Component\Gagallery\Administrator\Helper\GagalleryHelper;

/**
 * Single model.
 * @since  1.6
 */
class PictureModel extends AdminModel
{
	/**
	 * @var      string    The prefix to use with controller messages.
	 * @since    1.6
	 */
	protected $text_prefix = 'COM_GAGALLERY';

	/**
	 * @var   	string  	Alias to manage history control
	 * @since   3.2
	 */
	public $typeAlias = 'com_gagallery.picture';

	/**
	 * @var null  Item data
	 * @since  1.6
	 */
	protected $item = null;

	/**
	 * Returns a reference to the a Table object, always creating it.
	 * @param   string  $type    The table type to instantiate
	 * @param   string  $prefix  A prefix for the table class name. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 * @return    Table    A database object
	 * @since    1.6
	 */
	public function getTable($type = 'Picture', $prefix = 'Administrator', $config = array())
	{
		return parent::getTable($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 * @param   array    $data      An optional array of data for the form to interogate.
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not.
	 * @return  Form  A Form object on success, false on failure
	 * @since    1.6
     * @throws
	 */
	public function getForm($data = array(), $loadData = true)
	{
		// Initialise variables.
		$app = Factory::getApplication();
		
		// Get the form.
		$form = $this->loadForm( 
			'com_gagallery.picture', 
			'picture',
			array('control' => 'jform', 
			'load_data' => $loadData ) 
			);

		if (empty($form)) {
			//return false;
		}

		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 * @return   mixed  The data for the form.
	 * @since    1.6
     * @throws
	 */
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = Factory::getApplication()->getUserState('com_gagallery.edit.picture.data', array());

		if (empty($data)) {
			if ($this->item === null) {
				$this->item = $this->getItem();
			}

			$data = $this->item;

		}

		return $data;
	}

	/**
	 * Method to get a single record.
	 * @param   integer  $pk  The id of the primary key.
	 * @return  mixed    Object on success, false on failure.
	 * @since    1.6
	 */
	public function getItem($pk = null)
	{
		if ($item = parent::getItem($pk)) {
			if (isset($item->params)) {
				$item->params = json_encode($item->params);
			}
	
			// Do any procesing on fields here if needed
		}

		return $item;

	}

    /**
     * Method to save the form data.
     * @param   array  $data  The form data.
     * @return  boolean  True on success.
     * @since   1.6
     * Added this because when date fields are cleared, need null for date
     */
    public function save($data)
    {
        //$data['exp_date'] = isset($data['exp_date']) && !empty($data['exp_date']) ?: null;
        Factory::getApplication()->setUserState('com_gagallerys.test.data',$data);
        if (parent::save($data))
        {
    		// Clean cache
    		$this->cleanCache();

            return true;
        }

        return false;
	}

	/**
	 * Method to duplicate a Record
	 * @param   array  &$pks  An array of primary key IDs.
	 * @return  boolean  True if successful.
	 * @throws  Exception
	 */
	public function duplicate(&$pks)
	{
		$user = GagalleryHelper::getSpecificUser();

		// Access checks.
		if (!$user->authorise('core.create', 'com_gagallery')) {
			throw new \Exception(Text::_('JERROR_CORE_CREATE_NOT_PERMITTED'));
		}

		$table = $this->getTable();

		foreach ($pks as $pk) {

			if ($table->load($pk, true))
			{
				// Reset the id to create a new record.
				$table->id = 0;
				$table->state = 0;

				if (!$table->check()) {
					throw new \Exception($table->getError());
				}
				
				if (!$table->store(true)) {
					throw new \Exception($table->getError());
				}

			} else {
				throw new \Exception($table->getError());
			}
                    
		}

		// Clean cache
		$this->cleanCache();

		return true;
	}

	/**
	 * Method to null a date in Record
	 * @param   array  &$pks  An array of primary key IDs.
	 * @return  boolean  True if successful.
	 * @throws  Exception
	 */
	public function nullExpDate(&$pks)
	{
		$user = GagalleryHelper::getSpecificUser();

		// Access checks.
		if (!$user->authorise('core.manage', 'com_gagallery')) {
			throw new \Exception(Text::_('JERROR_CORE_MANAGE_NOT_PERMITTED'));
		}

		foreach ($pks as $pk)
        {
            $db = Factory::getContainer()->get('DatabaseDriver');
            $db->setQuery('UPDATE #__gagallery_pictures SET exp_date = NULL WHERE id = '.(int) $pk);
            try {
        		$db->execute();
        	} catch (RuntimeException $e) {
        	    throw new \Exception($e);
        	}

		}

		// Clean cache
		$this->cleanCache();

		return true;
	}

	/**
	 * Prepare and sanitise the table prior to saving.
	 * @param   Table  $table  Table Object
	 * @return void
	 * @since    1.6
	 */
	protected function prepareTable($table)
	{
		if (empty($table->id)) {
			// Set ordering to the last item if not set
			if (@$table->ordering === '') {
				$db = Factory::getContainer()->get('DatabaseDriver');
				$db->setQuery('SELECT MAX(ordering) FROM #__gagallery_pictures');
				$max             = $db->loadResult();
				$table->ordering = $max + 1;
			}
		}
	}
}
