<?php
/**
 * @version    3.0.2
 * @package    com_gagallery
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2021 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;


use \Joomla\CMS\HTML\HTMLHelper;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Uri\Uri;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Layout\LayoutHelper;
use \Joomla\CMS\Language\Text;
use \GlennArkell\Component\Gagallery\Administrator\Helper\GagalleryHelper;

/** @var \Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $this->document->getWebAssetManager();
/** This places the column filter button */
$wa->useScript('table.columns')
    ->useScript('multiselect')
    ->usePreset('com_gagallery.gagallerypreset');

$user      = GagalleryHelper::getSpecificUser();
$listOrder = $this->state->get('list.ordering', 'a.title');
$listDirn  = $this->state->get('list.direction', 'ASC');
$canOrder  = $user->authorise('core.edit.state', 'com_gagallery');
$saveOrder = $listOrder == 'a.ordering';
$version = GagalleryHelper::getComponentVersion();

if ($saveOrder) {
	$saveOrderingUrl = 'index.php?option=com_gagallery&task=pictures.saveOrderAjax&tmpl=component';
    HTMLHelper::_('sortablelist.sortable', 'pictureList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
}

/*
echo '<pre>Test<br />';
print_r(Factory::getApplication()->getUserState('com_gagallerys.test.data'));
echo '</pre>';
*/
?>

<form action="<?php echo Route::_('index.php?option=com_gagallery&view=pictures'); ?>" method="post"
	  name="adminForm" id="adminForm">
	<div class="row">
		<div class="col-md-12">
			<div id="j-main-container" class="j-main-container">

            	<?php echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>

				<div class="clearfix"></div>
				<table class="table table-striped" id="pictureList">
    				<caption id="captionTable">
    					<?php echo Text::_('Version: '.$version); ?>
    				</caption>
					<thead>
					<tr>
                        <td class="w-1 text-center">
                            <?php echo HTMLHelper::_('grid.checkall'); ?>
                        </td>
						<?php if (isset($this->items[0]->ordering)): ?>
							<th width="1%" class="nowrap center hidden-phone">
	                            <?php echo HTMLHelper::_('searchtools.sort', '', 'a.ordering', $listDirn, $listOrder, null, 'asc', 'JGRID_HEADING_ORDERING', 'icon-menu-2'); ?>
	                        </th>
						<?php endif; ?>
						<?php if (isset($this->items[0]->state)): ?>
							<th width="1%" class="nowrap center">
								<?php echo HTMLHelper::_('searchtools.sort', 'JSTATUS', 'a.state', $listDirn, $listOrder); ?>
							</th>
						<?php endif; ?>

						<th class='left'>
						<?php echo HTMLHelper::_('searchtools.sort',  'COM_GAGALLERY_PICTURES_TITLE', 'a.title', $listDirn, $listOrder); ?>
						</th>
						<th class='center'>
						<?php echo HTMLHelper::_('searchtools.sort',  'COM_GAGALLERY_PICTURES_IMG_NAME', 'a.img_name', $listDirn, $listOrder); ?>
						</th>
						<th class='left'>
						<?php echo HTMLHelper::_('searchtools.sort',  'COM_GAGALLERY_PICTURES_EXP_DATE', 'a.exp_date', $listDirn, $listOrder); ?>
						</th>
						<th class='left'>
						<?php echo HTMLHelper::_('searchtools.sort',  'COM_GAGALLERY_CREATED_DATE', 'a.created_date', $listDirn, $listOrder); ?>
						</th>
						<th class='left'>
						<?php echo HTMLHelper::_('searchtools.sort',  'COM_GAGALLERY_ID', 'a.id', $listDirn, $listOrder); ?>
						</th>

						
					</tr>
					</thead>
					<tfoot>
					<tr>
						<td colspan="<?php echo isset($this->items[0]) ? count(get_object_vars($this->items[0])) : 10; ?>">
							<?php echo $this->pagination->getListFooter(); ?>
						</td>
					</tr>
					</tfoot>
					<tbody>
					<?php foreach ($this->items as $i => $item) :
						$ordering   = ($listOrder == 'a.ordering');
						$canCreate  = $user->authorise('core.create', 'com_gagallery');
						$canEdit    = GagalleryHelper::canUserEdit($user, $item);
						$canCheckin = $user->authorise('core.manage', 'com_gagallery');
						$canChange  = $user->authorise('core.edit.state', 'com_gagallery');
						
						$img = HTMLHelper::cleanImageURL($item->img_name);

						?>
						<tr class="row<?php echo $i % 2; ?>">

							<td >
								<?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
							</td>
							<?php if (isset($this->items[0]->ordering)) : ?>
								<td class="order nowrap center hidden-phone">
									<?php if ($canChange) :
										$disableClassName = '';
										$disabledLabel    = '';

										if (!$saveOrder) {
											$disabledLabel    = Text::_('JORDERINGDISABLED');
											$disableClassName = 'inactive tip-top';
										}
									?>
										<span class="sortable-handler hasTooltip <?php echo $disableClassName ?>"
											  title="<?php echo $disabledLabel ?>">
											<i class="icon-menu"></i>
										</span>
										<input type="text" style="display:none" name="order[]" size="5"
											   value="<?php echo $item->ordering; ?>" class="width-20 text-area-order "/>
									<?php else : ?>
										<span class="sortable-handler inactive">
											<i class="icon-menu"></i>
										</span>
									<?php endif; ?>
								</td>
							<?php endif; ?>
							<?php if (isset($this->items[0]->state)): ?>
								<td class="center">
								<?php echo HTMLHelper::_('jgrid.published', $item->state, $i, 'pictures.', $canChange, 'cb'); ?>
								</td>
							<?php endif; ?>

							<td>
								<?php if (isset($item->checked_out) && $item->checked_out && ($canEdit || $canChange)) : ?>
									<?php echo HTMLHelper::_('jgrid.checkedout', $i, $item->uEditor, $item->checked_out_time, 'pictures.', $canCheckin); ?>
								<?php endif; ?>
								<?php if ($canEdit) : ?>
									<a href="<?php echo Route::_('index.php?option=com_gagallery&task=picture.edit&id='.(int) $item->id); ?>">
									<?php echo $this->escape($item->title); ?></a>
								<?php else : ?>
									<?php echo $this->escape($item->title); ?>
								<?php endif; ?>
							</td>
							<td>
								<?php if(!empty($img->url)) : ?>
                                    <img class="smalltn_p" src="../<?php echo $img->url; ?>" alt="" />
								<?php endif; ?>
							</td>
							<td>
								<?php echo $item->exp_date > 0 ? HTMLHelper::_('date', $item->exp_date, Text::_('COM_GAGALLERY_DISPLAY_DATE')) : '-'; ?>
							</td>
							<td>
								<?php echo $item->created_date > 0 ? HTMLHelper::_('date', $item->created_date, Text::_('COM_GAGALLERY_DISPLAY_DATE')) : '-'; ?>
							</td>

							<td><?php echo $item->id; ?></td>

						</tr>
					<?php endforeach; ?>
					</tbody>
				</table>

				<input type="hidden" name="task" value=""/>
				<input type="hidden" name="boxchecked" value="0"/>
	            <input type="hidden" name="list[fullorder]" value="<?php echo $listOrder; ?> <?php echo $listDirn; ?>"/>
				<?php echo HTMLHelper::_('form.token'); ?>
			</div>
		</div>
	</div>
</form>
