<?php
/**
 * @version    3.0.2
 * @package    com_gagallery
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2021 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace GlennArkell\Component\Gagallery\Site\Controller;

\defined('_JEXEC') or die;

use \Joomla\CMS\Application\SiteApplication;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Language\Multilanguage;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\MVC\Controller\BaseController;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Uri\Uri;
use \Joomla\Utilities\ArrayHelper;
use \Joomla\CMS\Menu\SiteMenu;
use \GlennArkell\Component\Gagallery\Administrator\Helper\GagalleryHelper;

/**
 * Item class.
 * @since  1.6.0
 */
class PictureController extends BaseController
{
	/**
	 * Method to check out an item for editing and redirect to the edit form.
	 * @return void
	 * @since    1.6
     * @throws Exception
	 */
	public function edit()
	{
		$app = Factory::getApplication();

		// Get the previous edit id (if any) and the current edit id.
		$previousId = (int) $app->getUserState('com_gagallery.edit.picture.id');
		$editId     = $app->input->getInt('id', 0);

		// Set the record id to edit in the session.
		$app->setUserState('com_gagallery.edit.picture.id', $editId);

		// Get the model.
		$model = $this->getModel('Picture', 'Site');

		// Check out the record
		if ($editId) {
			$model->checkout($editId);
		}

		// Check in the previous record.
		if ($previousId && $previousId !== $editId) {
			$model->checkin($previousId);
		}

		// Redirect to the edit screen.
		$this->setRedirect(Route::_('index.php?option=com_gagallery&view=pictureform&layout=edit', false));
	}

	/**
	 * Method to publish record
	 * @return    void
	 * @throws Exception
	 * @since    1.6
	 */
	public function publish()
	{
		// Initialise variables.
		$app = Factory::getApplication();

		// Get the user data.
		$id    = $app->input->getInt('id');
		$state = $app->input->getInt('state');

		// Checking if the user can action the object
		$user = GagalleryHelper::getSpecificUser();
		$item = GagalleryHelper::getRecord('#__gagallery_pictures', $id);
		$canEdit = GagalleryHelper::canUserEdit($user, $item);

		if ($canEdit)
		{
			$model = $this->getModel('Picture', 'Site');

			// Attempt to save the data.
			$return = $model->publish($id, $state);

			// Check for errors.
			if ($return === false)
			{
				$this->setMessage(Text::sprintf('COM_GAGALLERY_SAVE_FAILED', $model->getError()), 'warning');
			}

			// Clear the record id from the session.
			$app->setUserState('com_gagallery.edit.picture.id', null);

			// Flush the data from the session.
			$app->setUserState('com_gagallery.edit.picture.data', null);

			// Redirect to the list screen.
			$this->setMessage(Text::_('COM_GAGALLERY_ITEM_SAVED_SUCCESSFULLY'));
			$menu = Factory::getApplication()->getMenu();
			$item = $menu->getActive();

			if (!$item) {
				// If there isn't any menu item active, redirect to list view
				$this->setRedirect(Route::_('index.php?option=com_gagallery&view=pictures', false));
			} else {
                $this->setRedirect(Route::_('index.php?Itemid='. $item->id, false));
			}
		} else {
			throw new \Exception(500);
		}
	}

	/**
	 * Remove data
	 * @return void
	 * @throws Exception
	 */
	public function remove()
	{
		// Initialise variables.
		$app = Factory::getApplication();
		// Set up Redirect URL.
        $item = $app->getMenu()->getActive();
        $url = (empty($item->link) ? 'index.php?option=com_gagallery&view=pictures' : $item->link.'&Itemid='.$item->id);

		// Checking if the user can remove object
		$user = GagalleryHelper::getSpecificUser();

		if ($user->authorise('core.delete', 'com_gagallery'))
		{
			$model = $this->getModel('Picture', 'Site');

			// Get the user submitted data.
			$id = $app->input->getInt('id', 0);

			// Attempt to save the data.
			$return = $model->delete($id);

			// Check for errors.
			if ($return === false) {
				$this->setMessage(Text::sprintf(Text::_('COM_GAGALLERY_ITEM_DELETED_FAILED'), $model->getError()), 'warning');
			} else {
				// Check in the record.
				if ($return) {
					$model->checkin($return);
				}

                $app->setUserState('com_gagallery.edit.picture.id', null);
                $app->setUserState('com_gagallery.edit.picture.data', null);

                $app->enqueueMessage(Text::_('COM_GAGALLERY_ITEM_DELETED_SUCCESSFULLY'), 'success');
			}

            $this->setRedirect(Route::_($url, false));

		} else {
			throw new \Exception(500);
		}
	}

	/**
	 * Method to delete image file from record
	 * @return void
	 * @throws Exception
	 */
	public function deleteFile()
	{
		$app = Factory::getApplication();
        $menu = $app->getMenu()->getActive();
        $url = (empty($menu->link) ? 'index.php?option=com_gagallery&view=pictures' : $menu->link.'&Itemid='.$menu->id);

		// Get the current edit id.
		$id     = $app->input->getInt('id', 0);

		// Get the model.
		$model = $this->getModel('Picture', 'Site');

		// Attempt to save the data.
		$return = $model->deletefile($id);

		if ($return) {
			$model->checkin($id);
		}

		$this->setRedirect(Route::_($url, false));
	}

}
