<?php
/**
 * @version    3.0.2
 * @package    com_gagallery
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2021 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace GlennArkell\Component\Gagallery\Site\Controller;

\defined('_JEXEC') or die;

use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Utilities\ArrayHelper;
use \Joomla\CMS\Component\ComponentHelper;

/**
 * Form class.
 * @since  1.6.0
 */
class PictureformController extends FormController
{
	/**
	 * Method to check out an item for editing and redirect to the edit form.
	 * @return void
	 * @since    1.6
     * @throws Exception
	 */
	public function edit($key = NULL, $urlVar = NULL)
	{
		$app = Factory::getApplication();

		// Get the previous edit id (if any) and the current edit id.
		$previousId = (int) $app->getUserState('com_gagallery.edit.picture.id');
		$editId     = $app->input->getInt('id', 0);

		// Set the user id for the user to edit in the session.
		$app->setUserState('com_gagallery.edit.picture.id', $editId);

		// Get the model.
		$model = $this->getModel('Pictureform', 'Site');

		// Check out the record
		if ($editId) {
			$model->checkout($editId);
		}

		// Check in the previous record.
		if ($previousId) {
			$model->checkin($previousId);
		}

		// Redirect to the edit screen.
		$this->setRedirect(Route::_('index.php?option=com_gagallery&view=pictureform&layout=edit', false));
	}

	/**
	 * Method to save data.
	 * @return void
	 * @throws Exception
	 * @since  1.6
	 */
	public function save($key = NULL, $urlVar = NULL)
	{
		// Check for request forgeries.
		$this->checkToken();

		// Initialise variables.
		$app   = Factory::getApplication();
        $menu = $app->getMenu()->getActive();
        $url = (empty($menu->link) ? 'index.php?option=com_gagallery&view=pictures' : $menu->link.'&Itemid='.$menu->id);

		$model = $this->getModel('Pictureform', 'Site');
		
		$params = ComponentHelper::getParams('com_gagallery');
		$max_size  = $params->get( 'max_size', 500);
		$maxSize  = $max_size * 1000;
        //$app->setUserState('com_gagallery.test.data', $maxSize);

		// Get the user data.
		$data = $app->input->get('jform', array(), 'array');
		$files = $app->input->files->get('jform', '', 'array');

        foreach ($files as $file) {
			$data['img_name'] = $file;
            //$app->setUserState('com_gagallery.test.data', $file);

            if ($file['size'] > $maxSize) {
                $app->enqueueMessage(Text::sprintf('COM_GAGALLERY_FILE_SIZE_EXCEEDED', $max_size), 'danger');
                $app->setUserState('com_gagallery.edit.picture.data', $data);
    			$id = (int) $app->getUserState('com_gagallery.edit.picture.id');
                $this->setRedirect(Route::_('index.php?option=com_gagallery&view=pictureform&layout=edit&id=' . $id, false));
    			$this->redirect();
    		}
		}

		// Upload the image.
		$imgOK = $model->uplattachfile($data, 0);

		// Validate the posted data.
		$form = $model->getForm();

		if (!$form) {
			throw new \Exception($model->getError(), 500);
		}

		// Validate the posted data.
		$data = $model->validate($form, $data);

		// Check for errors.
		if ($data === false)
		{
			// Get the validation messages.
			$errors = $model->getErrors();

			// Push up to three validation messages out to the user.
			for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++) {
				if ($errors[$i] instanceof \Exception) {
					$app->enqueueMessage($errors[$i]->getMessage(), 'warning');
				} else {
					$app->enqueueMessage($errors[$i], 'warning');
				}
			}

			$input = $app->input;
			$jform = $input->get('jform', array(), 'ARRAY');

			// Save the data in the session.
			$app->setUserState('com_gagallery.edit.picture.data', $jform);

			// Redirect back to the edit screen.
			$id = (int) $app->getUserState('com_gagallery.edit.picture.id');
			$this->setRedirect(Route::_('index.php?option=com_gagallery&view=pictureform&layout=edit&id=' . $id, false));

			$this->redirect();
		}

		// Attempt to save the data.
		$return = $model->save($data);

		// Check for errors.
		if ($return === false)
		{
			// Save the data in the session.
			$app->setUserState('com_gagallery.edit.picture.data', $data);

			// Redirect back to the edit screen.
			$id = (int) $app->getUserState('com_gagallery.edit.picture.id');
			$app->enqueueMessage(Text::sprintf('Save failed', $model->getError()), 'warning');
			$this->setRedirect(Route::_('index.php?option=com_gagallery&view=pictureform&layout=edit&id=' . $id, false));
		}

		// Check in the record.
		if ($return) {
			$model->checkin($return);
		}

		// Clear the record id from the session.
		$app->setUserState('com_gagallery.edit.picture.id', null);

		// Flush the data from the session.
		$app->setUserState('com_gagallery.edit.picture.data', null);

		$app->enqueueMessage(Text::_('COM_GAGALLERY_ITEM_SAVED_SUCCESSFULLY'));

		// Redirect to the list screen.
		$this->setRedirect(Route::_($url, false));
	}

	/**
	 * Method to abort current operation
	 * @return void
	 * @throws Exception
	 */
	public function cancel($key = NULL)
	{
		$app = Factory::getApplication();
        $menu = $app->getMenu()->getActive();
        $url = (empty($menu->link) ? 'index.php?option=com_gagallery&view=pictures' : $menu->link.'&Itemid='.$menu->id);

		// Get the current edit id.
		$editId = (int) $app->getUserState('com_gagallery.edit.picture.id');

		// Get the model.
		$model = $this->getModel('Pictureform', 'Site');

		// Check in the record
		if ($editId) {
			$model->checkin($editId);
		}

		$this->setRedirect(Route::_($url, false));
	}

	/**
	 * Method to remove data
	 * @return void
	 * @throws Exception
     * @since 1.6
	 */
	public function remove()
    {
        $app   = Factory::getApplication();
		// Set up Redirect URL.
        $menu = $app->getMenu()->getActive();
        $url = (empty($menu->link) ? 'index.php?option=com_gagallery&view=pictures' : $menu->link.'&Itemid='.$menu->id);

        $model = $this->getModel('Pictureform', 'Site');
        $pk    = $app->input->getInt('id');

        // Attempt to save the data
        try
        {
            $return = $model->delete($pk);

            // Check in the record
            $model->checkin($return);

            // Clear the record id from the session.
            $app->setUserState('com_gagallery.edit.picture.id', null);

            // Redirect to the list screen
            $app->enqueueMessage(Text::_('COM_GAGALLERY_ITEM_DELETED_SUCCESSFULLY'));

            // Flush the data from the session.
            $app->setUserState('com_gagallery.edit.picture.data', null);
        }
        catch (\Exception $e)
        {
            $errorType = ($e->getCode() == '404') ? 'error' : 'warning';
            $app->enqueueMessage($e->getMessage(), $errorType);
        }
        $this->setRedirect(Route::_($url, false));
    }

	/**
	 * Method to load gallery records from folder
	 * @return void
	 * @throws Exception
	 * Warning this process is coming from a modal view the menu item is not passed automatically
	 */
	public function loadFileRecords()
    {
        $app   = Factory::getApplication();
		// Set up Redirect URL.
        $menu = $app->getMenu()->getActive();
        $url = (empty($menu->link) ? 'index.php?option=com_gagallery&view=pictures' : $menu->link.'&Itemid='.$menu->id);

        $model = $this->getModel('Pictureform', 'Site');

		// Get the user data.
		$data = $app->input->get('jform', array(), 'array');

        // Attempt to load records
        try
        {
            $return = $model->autoLoad($data);
            $app->enqueueMessage(Text::_('COM_GAGALLERY_ITEM_SAVED_SUCCESSFULLY'), 'success');
        }
        catch (\Exception $e)
        {
            $errorType = ($e->getCode() == '404') ? 'error' : 'warning';
            $app->enqueueMessage($e->getMessage(), $errorType);
        }

        // Clear the record id from the session.
        $app->setUserState('com_gagallery.edit.picture.id', null);

        // Flush the data from the session.
        $app->setUserState('com_gagallery.edit.picture.data', null);

		$this->setRedirect(Route::_($url, false));
    }

}
