<?php
/**
 * @version    3.0.2
 * @package    com_gagallery
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2021 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\HTML\HTMLHelper;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\Uri\Uri;
use \GlennArkell\Component\Gagallery\Administrator\Helper\GagalleryHelper;

// load any assets required
$this->document->getWebAssetManager()
    ->usePreset('com_gagallery.gagallerypreset');

// Load admin language file
$lang = Factory::getApplication()->getLanguage();
$lang->load('com_gagallery', JPATH_ADMINISTRATOR);

$user = GagalleryHelper::getSpecificUser();
$canEdit = GagalleryHelper::canUserEdit($user, $this->item);

$canDelete = $user->authorise('core.delete','com_gagallery.picture.'.$this->item->id);
$img = HTMLHelper::cleanImageURL($this->item->img_name);

// Display a heading for the page
if ($this->params->get('page_title', '') > '') {
	echo '<h2>'.$this->params->get('page_title').'</h2>';
} else { 
	echo '<h2>'.Text::_('COM_GAGALLERY_TITLE_PICTURE').'</h2>';
}
?>

<div class="item_fields">

	<table class="table">

		<tr>
			<th><?php echo Text::_('COM_GAGALLERY_FORM_LBL_PICTURE_TITLE'); ?></th>
			<td><?php echo $this->item->title; ?></td>
		</tr>

		<tr>
			<th><?php echo Text::_('COM_GAGALLERY_FORM_LBL_PICTURE_CAT_ID'); ?></th>
			<td><?php echo $this->item->cat_id_name; ?></td>
		</tr>

		<tr>
			<th><?php echo Text::_('COM_GAGALLERY_FORM_LBL_PICTURE_IMG_NAME'); ?></th>
			<td>
    			<a href="<?php echo Route::_(Uri::root() . $img->url, false); ?>" target="_blank">
                    <img src="<?php echo $img->url; ?>" />
                </a>

    		</td>
		</tr>

		<tr>
			<th><?php echo Text::_('COM_GAGALLERY_FORM_LBL_CREATED_DATE'); ?></th>
			<td><?php echo $this->item->created_date; ?></td>
		</tr>

		<tr>
			<th><?php echo Text::_('COM_GAGALLERY_FORM_LBL_MODIFIED_DATE'); ?></th>
			<td><?php echo $this->item->modified_date; ?></td>
		</tr>

		<tr>
			<th><?php echo Text::_('COM_GAGALLERY_FORM_LBL_PICTURE_EXP_DATE'); ?></th>
			<td><?php
					$tdate = $this->item->exp_date;
					echo $tdate > 0 ? HTMLHelper::_('date', $tdate, Text::_('DATE_FORMAT_LC6')) : '-';
				?>
			</td>
		</tr>

		<tr>
			<th><?php echo Text::_('COM_GAGALLERY_FORM_LBL_COMMENT'); ?></th>
			<td><?php echo nl2br($this->item->comment); ?></td>
		</tr>

		<tr>
			<th><?php echo Text::_('COM_GAGALLERY_FORM_LBL_OTHER_DETAILS'); ?></th>
			<td><?php echo 'Article Cat: '.$this->item->art_cat.'<br />Display Cat: '.$this->item->disp_cat.'<br />Display Article: '.$this->item->disp_art.'<br />Display Link: '.$this->item->disp_link; ?></td>
		</tr>

	</table>

</div>

<?php /* ----------------------   Return button   ------------------------------ */ ?>
<a class="btn btn-secondary" href="<?php echo Route::_('index.php?option=com_gagallery&task=picture.cancel'); ?>">
	<i class="icon-undo"></i> <?php echo Text::_("COM_GAGALLERY_RETURN"); ?>
</a>

<?php /* ----------------------   Edit button   ------------------------------ */ ?>
<?php if($canEdit && $this->item->checked_out == 0): ?>
	<a class="btn btn-warning"
		href="<?php echo Route::_('index.php?option=com_gagallery&task=picture.edit&id='.$this->item->id); ?>">
		<i class="icon-edit"></i> <?php echo Text::_("COM_GAGALLERY_EDIT_ITEM"); ?>
	</a>
<?php endif; ?>

<?php /* ----------------------   Delete button and modal  ------------------------------ */ ?>
<?php if ($canDelete) : ?>
	<button class="btn btn-danger w5rem mb-1" data-bs-target="#deleteModal" data-bs-toggle="modal">
		<i class="icon-trash"></i> <?php echo Text::_("COM_GAGALLERY_DELETE_ITEM"); ?>
	</button>

	<?php HTMLHelper::_('bootstrap.renderModal', 'deleteModal'); ?>

	<div id="deleteModal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="deleteModal" aria-hidden="true">
		<div class="modal-header">
			<button type="button" class="close" data-bs-dismiss="modal" aria-hidden="true">&times;</button>
			<h3><?php echo Text::_('COM_GAGALLERY_DELETE_ITEM'); ?></h3>
		</div>
		<div class="modal-body">
			<p><?php echo Text::sprintf('COM_GAGALLERY_DELETE_CONFIRM', $this->item->id); ?></p>
		</div>
		<div class="modal-footer">
			<button class="btn" data-bs-dismiss="modal">Close</button>
			<a class="btn btn-danger"
				href="<?php echo Route::_('index.php?option=com_gagallery&task=picture.remove&id=' . $this->item->id, false, 2); ?>">
				<?php echo Text::_('COM_GAGALLERY_DELETE_ITEM'); ?>
			</a>
		</div>
	</div>

<?php endif; ?>
