<?php
/**
 * @version    3.0.2
 * @package    com_gagallery
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2021 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\HTML\HTMLHelper;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Uri\Uri;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\Layout\LayoutHelper;
use \GlennArkell\Component\Gagallery\Administrator\Helper\GagalleryHelper;

// load any assets required
$this->document->getWebAssetManager()
    ->usePreset('com_gagallery.gagallerypreset');

// Load admin language file
$lang = Factory::getApplication()->getLanguage();
$lang->load('com_gagallery', JPATH_ADMINISTRATOR);

$user    = GagalleryHelper::getSpecificUser();
$canEdit = GagalleryHelper::canUserEdit($user, $this->item);
$canCheckin = $user->authorise('core.manage', 'com_gagallery');
$canEditOwn  = $user->authorise('core.edit.own', 'com_gagallery');

if (empty($this->item->img_name)) {
    $this->form->setFieldAttribute('img_name_txt', 'type', 'hidden');
    $delButton = 0;
} else {
    $this->form->setFieldAttribute('img_name_txt', 'default', $this->item->img_name);
    $this->form->setFieldAttribute('img_name_txt', 'readonly', 'readonly');
    $this->form->setFieldAttribute('img_name', 'type', 'hidden');

    $delButton = GagalleryHelper::getHTTPQuery(null, 'task', 'pictureform.delFile', 'id', 0);
    $delURL = 'index.php?'.\http_build_query($delButton, '', '&amp;');
}

/*
echo '<pre>Test<br />';
print_r(Factory::getApplication()->getUserState('com_gagallery.test.data'));
echo '</pre>';
*/

?>

<div class="picture-edit front-end-edit">
	<?php if (!$canEdit) : ?>
		<h3>
			<?php throw new \Exception(Text::_('COM_GAGALLERY_ERROR_MESSAGE_NOT_AUTHORISED'), 403); ?>
		</h3>
	<?php else : ?>
		<?php if (!empty($this->item->id)): ?>
			<h1><?php echo Text::sprintf('COM_GAGALLERY_EDIT_ITEM_TITLE', $this->item->title); ?></h1>
		<?php else: ?>
			<h1><?php echo Text::_('COM_GAGALLERY_ADD_ITEM_TITLE'); ?></h1>
		<?php endif; ?>

		<form id="form-picture"
			  action="<?php echo Route::_('index.php?option=com_gagallery&task=pictureform.save'); ?>"
			  method="post" class="form-validate form-horizontal" enctype="multipart/form-data">

			<?php echo HTMLHelper::_('uitab.startTabSet', 'myTab', array('active' => 'general')); ?>
			<?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'general', Text::_('COM_GAGALLERY_TAB_PICTURE', true)); ?>
		
				<div class="row-fluid">
					<div class="span10 form-horizontal">
						<fieldset name="general" class="adminform">
							<legend><?php echo Text::_('COM_GAGALLERY_TAB_PICTURE'); ?></legend>
							<?php echo $this->form->renderFieldset('general'); ?>
						</fieldset>
					</div>
				</div>

				<div class="row-fluid">
					<div class="span10 form-horizontal">
						<fieldset name="general" class="adminform">
							<legend><?php echo Text::_('COM_GAGALLERY_TAB_IMAGE'); ?></legend>
							<?php echo $this->form->renderFieldset('tranfiles'); ?>
        					<a class="btn btn-danger" style="margin-left:190px;" href="<?php echo Route::_($delURL); ?>" title="<?php echo Text::_('JTOOLBAR_DELFILE'); ?>">
        					   <span class="icon-trash" aria-hidden="true"></span> <?php echo Text::_('JTOOLBAR_DELFILE'); ?>
        					</a>
						</fieldset>
					</div>
				</div>

			<?php echo HTMLHelper::_('uitab.endTab'); ?>

			<?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'extrainfo', Text::_('COM_GAGALLERY_XTRAINFO', true)); ?>
				<div class="row-fluid">
					<div class="span10 form-horizontal">
						<fieldset name="extrainfo" class="adminform">
							<?php echo $this->form->renderFieldset('extrainfo'); ?>
						</fieldset>
					</div>
				</div>
			<?php echo HTMLHelper::_('uitab.endTab'); ?>
		
			<?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'sysinfo', Text::_('COM_GAGALLERY_SYSINFO', true)); ?>
				<div class="row-fluid">
					<div class="span10 form-horizontal">
						<fieldset name="sysinfo" class="adminform">
							<?php echo $this->form->renderFieldset('sysinfo'); ?>
						</fieldset>
					</div>
				</div>
			<?php echo HTMLHelper::_('uitab.endTab'); ?>
	
			<?php echo HTMLHelper::_('uitab.endTabSet'); ?>

			<div class="control-group">
				<div class="controls">

					<?php if ($this->canSave): ?>
						<button type="submit" class="validate btn btn-primary">
							<span class="fas fa-check" aria-hidden="true"></span>
							<?php echo Text::_('JSUBMIT'); ?>
						</button>
					<?php endif; ?>
					<a class="btn btn-danger"
					   href="<?php echo Route::_('index.php?option=com_gagallery&task=pictureform.cancel'); ?>"
					   title="<?php echo Text::_('JCANCEL'); ?>">
					   <span class="fas fa-times" aria-hidden="true"></span>
						<?php echo Text::_('JCANCEL'); ?>
					</a>
				</div>
			</div>

			<input type="hidden" name="option" value="com_gagallery"/>
			<input type="hidden" name="task" value="pictureform.save"/>
			<?php echo HTMLHelper::_('form.token'); ?>
		</form>
	<?php endif; ?>
</div>
