<?php
/**
 * @version    3.0.2
 * @package    com_gagallery
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2021 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;


use \Joomla\CMS\HTML\HTMLHelper;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Uri\Uri;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Layout\LayoutHelper;
use \Joomla\CMS\Language\Text;
use \GlennArkell\Component\Gagallery\Administrator\Helper\GagalleryHelper;

// load any assets required
$wa = $this->document->getWebAssetManager();
$wa->usePreset('com_gagallery.gagallerypreset');
GagalleryHelper::loadTmplStyleModal($wa);


// Load admin language file
$lang = Factory::getLanguage();
$lang->load('com_gagallery', JPATH_ADMINISTRATOR);

$user      = GagalleryHelper::getSpecificUser();
$this->form->setFieldAttribute('img_name', 'type', 'hidden');
$this->form->setFieldAttribute('img_name_txt', 'type', 'hidden');

/*
$safeFileOptions  = $this->params->get( 'safe_files' );
echo '<pre>Test<br />';
print_r($safeFileOptions);
echo '</pre>';
*/
?>

<div class="front-end-edit">
    <form action="<?php echo Route::_('index.php?option=com_gagallery&task=pictureform.loadFileRecords'); ?>"
    	method="post" enctype="multipart/form-data" id="picture-form"
         target="_parent" class="form-validate form-horizontal">
    
        <div class="row-fluid">
            <div class="span12 form-horizontal">
    			<fieldset name="loadfiles" class="adminform">
    				<legend><?php echo Text::_('COM_GAGALLERY_FIELDSET_LOADFILES'); ?></legend>
    				<?php echo $this->form->renderField('cat_id'); ?>
    				<?php echo $this->form->renderFieldset('loadfolders'); ?>
    			</fieldset>
            </div>
            <p class="center">
                <button type="submit" class="validate btn btn-primary"><?php echo Text::_('JSUBMIT'); ?></button>
            </p>
        </div>
        <div>
        	<input type="hidden" name="task" value="pictureform.loadFileRecords"/>
        	<?php echo HTMLHelper::_('form.token'); ?>
        </div>
    
    </form>
</div>
