<?php
/**
 * @version    3.0.2
 * @package    com_gagallery
 * @author     Glenn Arkell <glenn@glennarkell.com.au>
 * @copyright  2021 Glenn Arkell
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\HTML\HTMLHelper;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Uri\Uri;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Language;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\Layout\LayoutHelper;
use \Joomla\CMS\Component\ComponentHelper;
use \GlennArkell\Component\Gagallery\Administrator\Helper\GagalleryHelper;

// load any assets required
$wa = $this->document->getWebAssetManager();
$wa->usePreset('com_gagallery.gagallerypreset');

// Load admin language file
$lang = Factory::getLanguage();
$lang->load('com_gagallery', JPATH_ADMINISTRATOR);

$listOrder  = $this->state->get('list.ordering', 'a.title');
$listDirn   = $this->state->get('list.direction', 'asc');

$Itemid = Factory::getApplication()->getMenu()->getActive()->id;

$cntr = 0;
$autoLoad = $this->params->get('allow_autoload', 0);
$showBorder   = $this->params->get('show_border', 0);
$header_text   = $this->params->get('header_text');
$thn_across   = $this->params->get('thn_across');
$modal_view   = $this->params->get('modal_view');
$viewPublic = $this->params->get('view_type', 0);
$holdover = array();
$tdwidth = 95 / $thn_across;

$user       = GagalleryHelper::getSpecificUser();
$canCreate  = $user->authorise('core.create', 'com_gagallery');
$canEdit    = $user->authorise('core.edit', 'com_gagallery');
$canCheckin = $user->authorise('core.manage', 'com_gagallery');
$canChange  = $user->authorise('core.edit.state', 'com_gagallery');
$canEditOwn  = $user->authorise('core.edit.own', 'com_gagallery');
$canDelete  = $user->authorise('core.delete', 'com_gagallery');

$baseURL = 'index.php?';
$createTran = GagalleryHelper::getHTTPQuery(null, 'task', 'picture.edit', 'id', 0);
$createURL = $baseURL.\http_build_query($createTran, '', '&amp;');

// set up autoload modal link
$loadLink = GagalleryHelper::getHTTPQuery(null, 'view', 'pictureform', 'id', 0);
$loadLink = GagalleryHelper::getHTTPQuery($loadLink, null, null, 'tmpl', 'component');
$loadLink = GagalleryHelper::getHTTPQuery($loadLink, null, null, 'layout', 'modal');
$modalParams = array(
    'url'        => 'index.php?'.http_build_query($loadLink, '', '&amp;'),
    'title'      => Text::_('COM_GAGALLERY_AUTOLOAD_LABEL'),
    'closeButton'=> true, 'modalWidth' => 50, 'bodyHeight' => 45, 'backdrop' => 'static' );
$modalname = 'modal-addImages';
$html = '<a class="btn btn-info pull-right" href="#'.$modalname.'" data-bs-toggle="modal">';
$html .= '<i class="icon-upload"></i> '.Text::_('COM_GAGALLERY_ALLOW_AUTOLOAD_LABEL').'</a>';

if ($this->params->get('show_border', 0)) {
    $wa->addInlineStyle('figure {border: thin silver solid;}');
}
if ($this->params->get('cap_bg', '')) {
    $wa->addInlineStyle('tr.gagallery {background-color: '.$this->params->get('cap_bg').';}');
}
if ($this->params->get('cap_txt', '')) {
    $wa->addInlineStyle('figcaption {color: '.$this->params->get('cap_txt').';}');
}

/*
echo '<pre>Test<br />';
print_r(Factory::getApplication()->getUserState('com_gagallery.test.data'));
echo '</pre>';
print_r(Factory::getApplication()->getUserState('com_gagallery.test.data'));
print_r($component);
*/

// Display a heading for the page
if ($this->params->get('page_title', '') > '') {
	echo '<div class="page-header"><h1 itemprop="headline">'.$this->params->get('page_title').'</h1></div>';
} else {
	echo '<div class="page-header"><h1 itemprop="headline">'.Text::_('COM_GAGALLERY_TITLE_PICTURES').'</h1></div>';
}
?>

<?php if ($viewPublic): ?>
    <h6 class="center" style="padding:20px 0;"><?php echo $header_text; ?></h6>
    <div class="table-responsive com-contact-categories categories-list">
	    <table class="gagallery">
	        <?php
                foreach ($this->items as $item) {
                    
                    $status = $canCheckin && !$item->state ? ' red_highlight' : '';
                    // check if link to go to articles etc (0 = , 1 = , 2 = )
                    if ($item->art_cat == 0) {
                        $link = $item->img_name.'" target="_blank';
                    } elseif ($item->art_cat == 1) {
                        if ($item->disp_cat) {
                            $catLink = GagalleryHelper::getHTTPQuery(null, 'view', 'category', 'id', $item->disp_cat);
                            $catLink = GagalleryHelper::getHTTPQuery($catLink, null, null, 'layout', 'blog');
                            $link = $baseURL.\http_build_query($catLink, '', '&amp;');
                        }
                    } elseif ($item->art_cat == 2) {
                        if ($item->disp_art) {
                            $artLink = GagalleryHelper::getHTTPQuery(null, 'view', 'article', 'id', $item->disp_art);
                            $artLink = GagalleryHelper::getHTTPQuery($artLink, null, null, 'Itemid', $Itemid);
                            $link = Route::_($baseURL.\http_build_query($artLink, '', '&amp;'));
                        }
                    } else {
                        if (!empty($item->disp_link)) {
                            $link = 'index.php/'.$item->disp_link;
                        }
                    }

                    $link = isset($link) && !empty($link) ? $link : '#';

                    $imgDet = '<td class="dispImg" width="'.$tdwidth.'%">';
                    $imgDet .= '<a class="text-decoration-none" href="'.$link.'">';
                    $imgDet .= '<figure class="center">';
                    $imgDet .= '<img class="thumbnail rounded center" src="'.$item->img_name.'" title="'.$item->title.'" />';
                    $imgDet .= '<figcaption class="center'.$status.'">'.$item->title.'</figcaption></figure></a></td>';
                    $holdover[] = $imgDet;
                    $cntr++;
                    if ($cntr == $thn_across) {
                        echo '<tr class="gagallery">';
                        foreach ($holdover AS $rec) {
                            echo $rec;
                        }
                        echo '</tr>';
                        $cntr = 0;
                        $holdover = array();
                    }
                }

                // clean up dregs in case some left over
                if ($cntr) {
                    $qtyImgs = count($holdover);
                    echo '<tr class="gagallery">';
                    foreach ($holdover AS $rec) {
                        echo $rec;
                    }
                    if ($cntr == 1) {
                        echo '<td class="dispImg" width="'.$tdwidth.'%">&nbsp;</td>';
                        echo '<td class="dispImg" width="'.$tdwidth.'%">&nbsp;</td>';
                    } elseif ($cntr == 2) {
                        echo '<td class="dispImg" width="'.$tdwidth.'%">&nbsp;</td>';
                    }
                    echo '</tr>';
                }
            ?>
	    </table>
    </div>
<?php else: ?>

    <form action="<?php echo htmlspecialchars(Uri::getInstance()->toString()); ?>" method="post"
          name="adminForm" id="adminForm" class="com-content-category__articles">
    
    	<?php
            // display standard joomla filter files
            //echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this));
            // display component view specific filter files
            echo LayoutHelper::render('default_filter', array('view' => $this), dirname(__FILE__));
        ?>

        <div class="table-responsive com-contact-categories categories-list">
    	<table class="table table-striped" id="pictureList">
    		<thead>
    		<tr>
    			<?php if (isset($this->items[0]->state)): ?>
    				<th width="5%">
    					<?php echo HTMLHelper::_('grid.sort', 'JPUBLISHED', 'a.state', $listDirn, $listOrder); ?>
    				</th>
    			<?php endif; ?>
    
    			<th class=''>
    				<?php echo HTMLHelper::_('grid.sort',  'COM_GAGALLERY_PICTURES_TITLE', 'a.title', $listDirn, $listOrder); ?>
    			</th>
    			<th class=''>
    				<?php echo HTMLHelper::_('grid.sort',  'COM_GAGALLERY_PICTURES_EXP_DATE', 'a.exp_date', $listDirn, $listOrder); ?>
    			</th>
    			<th class=''>
    				<?php echo HTMLHelper::_('grid.sort',  'COM_GAGALLERY_PICTURES_CAT_ID', 'a.cat_id', $listDirn, $listOrder); ?>
    			</th>
    			<th class=''>
    				<?php echo HTMLHelper::_('grid.sort',  'COM_GAGALLERY_PICTURES_IMG_NAME', 'a.img_name', $listDirn, $listOrder); ?>
    			</th>

    			<?php if ($canEditOwn || $canCheckin || $canDelete): ?>
    				<th class="center">
    					<?php echo Text::_('COM_GAGALLERY_ACTIONS'); ?>
    				</th>
    			<?php endif; ?>
    
    		</tr>
    		</thead>
    		<tfoot>
    		<tr>
    			<td colspan="<?php echo isset($this->items[0]) ? count(get_object_vars($this->items[0])) : 10; ?>">
    				<?php echo $this->pagination->getListFooter(); ?>
    			</td>
    		</tr>
    		</tfoot>
    		<tbody>
    		<?php foreach ($this->items as $i => $item) : ?>
    			<?php
    
                    $canEdit = GagalleryHelper::canUserEdit($user, $item);
    
                    $linkTran = GagalleryHelper::getHTTPQuery(null, 'view', 'picture', 'id', $item->id);
                    $appURL = $baseURL.\http_build_query($linkTran, '', '&amp;');
    
                    $editTran = GagalleryHelper::getHTTPQuery(null, 'task', 'picture.edit', 'id', $item->id);
                    $editURL = $baseURL.\http_build_query($editTran, '', '&amp;');
    
                    $removeTran = GagalleryHelper::getHTTPQuery(null, 'task', 'picture.remove', 'id', $item->id);
                    $removeURL = $baseURL.\http_build_query($removeTran, '', '&amp;');
    
                    $archTran = GagalleryHelper::getHTTPQuery(null, 'task', 'picture.publish', 'id', $item->id);
                    $archTran = GagalleryHelper::getHTTPQuery($archTran, null, null, 'state', 2);
                    $archURL = $baseURL.\http_build_query($archTran, '', '&amp;');

                    $trashFile = GagalleryHelper::getHTTPQuery(null, 'task', 'picture.deleteFile', 'id', $item->id);
                    $trashURL = $baseURL.\http_build_query($trashFile, '', '&amp;');

                    
                    $img = HTMLHelper::cleanImageURL($item->img_name);

                ?>
    
    			<tr class="row<?php echo $i % 2; ?>">
    
    				<?php if (isset($this->items[0]->state)) : ?>
    					<?php $class = ($canChange) ? 'active' : 'disabled'; ?>
    					<td class="center">
    						<a class="btn btn-micro <?php echo $class; ?>" href="<?php echo ($canChange) ? Route::_('index.php?option=com_gagallery&task=picture.publish&id=' . $item->id . '&state=' . (($item->state + 1) % 2), false, 2) : '#'; ?>">
    						<?php if ($item->state == 1): ?>
    							<i class="icon-publish"></i>
    						<?php else: ?>
    							<i class="icon-unpublish"></i>
    						<?php endif; ?>
    						</a>
    					</td>
    				<?php endif; ?>
    
    				<td>
    					<?php if (isset($item->checked_out) && $item->checked_out) : ?>
    						<?php echo HTMLHelper::_('jgrid.checkedout', $i, $item->uEditor, $item->checked_out_time, 'pictures.', $canCheckin); ?>
    					<?php endif; ?>
    					<a href="<?php echo Route::_($appURL); ?>">
    						<?php echo $this->escape($item->title); ?>
    					</a>
    				</td>
    				<td>
    					<?php echo $item->exp_date > 0 ? HTMLHelper::_('date', $item->exp_date, Text::_('COM_GAGALLERY_DISPLAY_DATE')) : '-'; ?>
    				</td>
    				<td>
    					<?php echo $item->cat_id_name; ?>
    				</td>
    				<td>
    					<?php if (!empty($img->url) && file_exists($img->url)) : ?>
        					<a title="Review the image" href="<?php echo Route::_(Uri::root() . $img->url, false); ?>" target="_blank" >
        						<i class="icon-search"></i>
        					</a>
    					<?php endif; ?>
    				</td>

    
    				<?php if ($canEditOwn || $canCheckin || $canDelete): ?>
    					<td class="center">
    						<a href="<?php echo Route::_($archURL); ?>" class="btn btn-info"
                                type="button" title="<?php echo Text::_('COM_GAGALLERY_MARK_ARCHIVED'); ?>">
                                <i class="icon-archive" ></i>
                            </a>
    						<?php if ($canEdit): ?>
    							<a href="<?php echo Route::_($editURL); ?>" class="btn btn-warning" type="button">
                                    <i class="icon-edit" ></i>
                                </a>
    						<?php endif; ?>
    						<?php if ($canDelete): ?>
    							<a href="<?php echo Route::_($removeURL); ?>" class="btn btn-danger delete-button" type="button">
                                    <i class="icon-trash" title="<?php echo Text::_('JTOOLBAR_DELETE'); ?>"></i>
                                </a>
    							<a href="<?php echo Route::_($trashURL); ?>" class="btn btn-danger trash-opaq" type="button">
                                    <i class="fa-solid fa-file-circle-xmark" title="<?php echo Text::_('JTOOLBAR_DELFILE'); ?>" ></i>
                                </a>
    						<?php endif; ?>
    					</td>
    				<?php endif; ?>
    
    			</tr>
    		<?php endforeach; ?>
    		</tbody>
    	</table>
        </div>
    	<?php if ($canCreate) : ?>
    		<a href="<?php echo Route::_($createURL, false, 0); ?>" class="btn btn-success btn-small">
                <i class="icon-plus"></i> <?php echo Text::_('COM_GAGALLERY_ADD_ITEM'); ?>
            </a>
        	<?php if ($canCreate && $autoLoad) : ?>
        		<?php echo $html .= HTMLHelper::_('bootstrap.renderModal', $modalname, $modalParams); ?>
        	<?php endif; ?>
    	<?php endif; ?>

    	<input type="hidden" name="task" value=""/>
    	<input type="hidden" name="boxchecked" value="0"/>
    	<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>"/>
    	<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>"/>
    	<?php echo HTMLHelper::_('form.token'); ?>
    </form>
<?php endif; ?>

<?php if($canDelete) : ?>
<script type="text/javascript">

	jQuery(document).ready(function () {
		jQuery('.delete-button').click(deleteItem);
	});

	function deleteItem() {

		if (!confirm("<?php echo Text::_('COM_GAGALLERY_DELETE_MESSAGE'); ?>")) {
			return false;
		}
	}
</script>
<?php endif; ?>
